/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.client.sound;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.client.sound.ISoundInstance;
import org.orecruncher.dsurround.client.sound.SoundState;
import org.orecruncher.dsurround.lib.compat.ModEnvironment;
import org.orecruncher.lib.random.XorShiftRandom;
import paulscode.sound.SoundSystemConfig;

@SideOnly(value=Side.CLIENT)
public class SoundInstance
extends PositionedSound
implements ISoundInstance {
    protected static final float ATTENUATION_OFFSET = 32.0f;
    protected static final Random RANDOM = XorShiftRandom.current();
    protected final BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
    protected float volumeThrottle = 1.0f;
    protected SoundState state = SoundState.NONE;
    protected boolean canQueue;

    SoundInstance(@Nonnull SoundEvent event, @Nonnull SoundCategory cat) {
        this(event.func_187503_a(), cat);
    }

    SoundInstance(@Nonnull ResourceLocation soundResource, @Nonnull SoundCategory cat) {
        super(soundResource, cat);
        this.field_147662_b = 1.0f;
        this.field_147663_c = 1.0f;
        this.setPosition(0.0f, 0.0f, 0.0f);
        this.field_147659_g = false;
        this.field_147665_h = 0;
        this.field_147666_i = ISound.AttenuationType.LINEAR;
        this.field_184367_a = SoundHandler.field_147700_a;
    }

    @Override
    public SoundState getState() {
        return this.state;
    }

    @Override
    public void setState(@Nonnull SoundState state) {
        this.state = state;
    }

    public SoundInstance setCategory(@Nonnull SoundCategory cat) {
        this.field_184368_b = cat;
        return this;
    }

    public SoundInstance setVolume(float v) {
        this.field_147662_b = v;
        return this;
    }

    public SoundInstance setPitch(float p) {
        this.field_147663_c = p;
        return this;
    }

    public SoundInstance setPosition(float x, float y, float z) {
        this.field_147660_d = x;
        this.field_147661_e = y;
        this.field_147658_f = z;
        this.pos.func_189532_c((double)x, (double)y, (double)z);
        return this;
    }

    public SoundInstance setPosition(@Nonnull Vec3i pos) {
        return this.setPosition((float)pos.func_177958_n() + 0.5f, (float)pos.func_177956_o() + 0.5f, (float)pos.func_177952_p() + 0.5f);
    }

    public SoundInstance setPosition(@Nonnull Vec3d pos) {
        return this.setPosition((float)pos.field_72450_a, (float)pos.field_72448_b, (float)pos.field_72449_c);
    }

    public float func_147654_h() {
        float y = super.func_147654_h();
        return this.func_147656_j() == ISound.AttenuationType.NONE ? y + 32.0f : y;
    }

    public SoundInstance setAttenuationType(@Nonnull ISound.AttenuationType type) {
        this.field_147666_i = type;
        return this;
    }

    public SoundInstance setRepeat(boolean flag) {
        this.field_147659_g = flag;
        return this;
    }

    public SoundInstance setRepeatDelay(int delay) {
        this.field_147665_h = delay;
        return this;
    }

    public SoundInstance setVolumeThrottle(float throttle) {
        this.volumeThrottle = throttle;
        return this;
    }

    @Override
    public void setQueue(boolean f) {
        this.canQueue = f;
    }

    @Override
    public boolean getQueue() {
        return this.canQueue;
    }

    public float func_147653_e() {
        return super.func_147653_e() * this.volumeThrottle;
    }

    public void fade() {
    }

    public void unfade() {
    }

    public boolean isFading() {
        return false;
    }

    public boolean isDonePlaying() {
        return this.getState().isTerminal();
    }

    @Override
    public boolean canSoundBeHeard() {
        return this.field_147662_b > 0.0f && (this.func_147656_j() == ISound.AttenuationType.NONE || SoundSystemConfig.getMasterGain() > 0.0f);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Sound{");
        builder.append(this.func_147650_b().toString());
        builder.append(", ").append(this.func_184365_d().toString());
        builder.append(", ").append(this.func_147656_j().toString());
        builder.append(", ").append(this.getState().toString());
        builder.append(", v:").append(this.func_147653_e());
        builder.append(", p:").append(this.func_147655_f());
        builder.append(", locX:").append(this.func_147649_g());
        builder.append(", locY:").append(this.func_147654_h());
        builder.append(", locZ:").append(this.func_147651_i());
        builder.append("}");
        return builder.toString();
    }

    public static ISound.AttenuationType noAttenuation() {
        return ModEnvironment.SoundPhysics.isLoaded() ? ISound.AttenuationType.LINEAR : ISound.AttenuationType.NONE;
    }
}

